/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.items;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import noppes.npcs.CustomNpcs;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.CustomRegisters;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.item.INPCToolItem;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.util.CustomNPCsScheduler;
import noppes.npcs.util.IPermission;
import noppes.npcs.util.Util;

public class ItemNpcWand
extends Item
implements IPermission,
INPCToolItem {
    public ItemNpcWand() {
        this.setRegistryName("customnpcs", "npcwand");
        this.func_77655_b("npcwand");
        this.func_77664_n();
        this.field_77777_bU = 1;
        this.func_77637_a(CustomRegisters.tab);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> list, @Nonnull ITooltipFlag flagIn) {
        list.add(new TextComponentTranslation("info.item.wand", new Object[0]).func_150254_d());
        for (int i = 0; i < 3; ++i) {
            list.add(new TextComponentTranslation("info.item.wand." + i, new Object[0]).func_150254_d());
        }
    }

    public int func_77626_a(@Nonnull ItemStack par1ItemStack) {
        return 72000;
    }

    @Override
    public boolean isAllowed(EnumPacketServer e) {
        return true;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, @Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
        }
        CustomNpcs.proxy.openGui(0, 0, 0, EnumGuiType.NpcRemote, player);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    @Nonnull
    public EnumActionResult func_180614_a(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumHand hand, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        if (CustomNpcs.OpsOnly && !Objects.requireNonNull(player.func_184102_h()).func_184103_al().func_152596_g(player.func_146103_bH())) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("availability.permission", new Object[0]));
        } else if (CustomNpcsPermissions.hasPermission(player, CustomNpcsPermissions.NPC_CREATE)) {
            Entity rayTraceEntity = Util.instance.getLookEntity((Entity)player, 4.0, false);
            if (rayTraceEntity instanceof EntityNPCInterface) {
                if (CustomNpcsPermissions.hasPermission(player, CustomNpcsPermissions.NPC_GUI)) {
                    NoppesUtilServer.sendOpenGui(player, EnumGuiType.MainMenuDisplay, (EntityNPCInterface)rayTraceEntity);
                }
                return EnumActionResult.FAIL;
            }
            EntityCustomNpc npc = new EntityCustomNpc(world);
            npc.ais.setStartPos(pos.func_177984_a());
            npc.func_70012_b((float)pos.func_177958_n() + 0.5f, npc.getStartYPos(), (float)pos.func_177952_p() + 0.5f, player.field_70177_z, player.field_70125_A);
            world.func_72838_d((Entity)npc);
            npc.func_70606_j(npc.func_110138_aP());
            CustomNPCsScheduler.runTack(() -> NoppesUtilServer.sendOpenGui(player, EnumGuiType.MainMenuDisplay, npc), 100);
        } else {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("availability.permission", new Object[0]));
        }
        return EnumActionResult.SUCCESS;
    }

    @Nonnull
    public ItemStack func_77654_b(@Nonnull ItemStack stack, @Nonnull World worldIn, @Nonnull EntityLivingBase playerIn) {
        return stack;
    }
}

